

export class ResetPasswordRequestWidget {
	
	
	tpl = `
		<div class="reset-password-widget">
			<h1>{{_('Reset password')}}</h1>
			
			<div style="height: 10px;"></div>
			
			<div id="reset-password-widget-content">
				<table>
					<tr>
						<td>
							{{_('Username or e-mail')}}
						</td>
						<td>
							<input type="text" name="username_email" />
							
							<img src="static/img/ajax-loader-small.gif" class="ajx-loader hidden" />
						</td>
					</tr>
					<tr>
						<td colspan="2" align="right">
							<div style="height: 10px;"></div>
							
							<div id="reset-password-error" class="error"></div>
							
							<button [onclick]="widget.cancel_Click">{{_('Cancel')}}</button>
							
							<button [onclick]="widget.resetMail_Click">{{_('Reset password')}}</button>
						</td>
					</tr>
				</table>
			</div>
		</div>
	`;
	
	
	container = null;
	
	
	init() {
		
		this.container = document.createElement('div');
		this.container.className = 'popup-authentication popup-reset-password';
		this.container.style.zIndex = '90004';
		
		document.querySelector('.auth-container').appendChild( this.container );
		
		this.render();
		
		
		this.container.style.height = $('.popup-authentication').outerHeight() + 'px';
		
	}
	
	
	
	render() {
		
		
		let eztpl = new EzTemplate( this.container );
		eztpl.loadHtml( this.tpl );
		eztpl.setObject('widget', this);
		eztpl.render();
		
	}
	
	
	async resetMail_Click() {
		
		let v = document.querySelector('.reset-password-widget input[name=username_email]').value;
		
		document.querySelector('.reset-password-widget .ajx-loader').className = 'ajx-loader';
		document.querySelector('.reset-password-widget input[name=username_email]').setAttribute('disabled', 'disabled');
		
		try {
			let r = await postUrl('/service/auth.do', {
				a: 'requestPasswordReset',
				username_email: v
			});
			
			let json = await r.json();
			
			
			if (json.success) {
				document.getElementById('reset-password-widget-content').innerText = 'Er is zojuist een e-mail verstuurd met een link waarmee u uw wachtwoord kunt resetten.';
				
				let c = document.createElement('div');
				let btn = document.createElement('button');
				btn.innerText = 'Ok';
				btn.onclick = () => {
					this.cancel_Click();
				}
				c.appendChild(btn);
				document.getElementById('reset-password-widget-content').appendChild( c );
				
			}
			else if (json.message) {
				document.getElementById('reset-password-error').innerText = 'Error: ' + json.message;
			}
			else {
				document.getElementById('reset-password-error').innerText = 'Error occured';
			}
			
			
			
		} catch (err) {
			console.log(err);
			alert('Error: ' + err);
		}
		
		document.querySelector('.reset-password-widget .ajx-loader').className = 'ajx-loader hidden';
		if (document.querySelector('.reset-password-widget input[name=username_email]'))
			document.querySelector('.reset-password-widget input[name=username_email]').removeAttribute( 'disabled' );
		
	}
	
	
	cancel_Click() {
		$('.popup-reset-password').remove();
	}
	
	
}


